/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspHmcInformation;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspHmcInfoData {
    private UnsignedInt16 mCurSlotNum;
    private String mHmcInfo;
    private static final String GET_HMC_INFO = "GET_HMC_INFO";
    private static final String SET_HMC_INFO = "SET_HMC_INFO";
    private static final String GET_NUMBER_OF_HMC_INFO_SLOTS = "GET_NUMBER_OF_HMC_INFO_SLOTS";
    private static final String SLOT = "SLOT";
    private static final String INFO = "INFO";
    private UnsignedInt32 mTotalResponseLen;
    private UnsignedInt16 mHeaderSize;
    private UnsignedInt8 mHmcInfoCount;
    private FspHmcInformation[] mHmcInfoList;
    private static final String GET_HMC_INFORMATION = "GET_HMC_INFORMATION";
    private static final String RESPONSE_LENGTH = "RESPONSE_LENGTH";
    private static final String HEADER_SIZE = "HEADER_SIZE";
    private static final String REPEATS = "REPEATS";
    private static final String HMC_INFO_LIST = "HMC_INFO_LIST";
    private static final String STRUCT_LENGTH = "STRUCT_LENGTH";
    private static final String CONNECTION_STATUS = "CONNECTION_STATUS";
    private static final String TOOL_TYPE = "TOOL_TYPE";
    private static final String HMC_ID_LENGTH = "HMC_ID_LENGTH";
    private static final String HMC_ID = "HMC_ID";
    private static FspHmcInfoData mInst;

    public UnsignedInt16 getCurSlotNum() {
        return this.mCurSlotNum;
    }

    public String getHmcInfo() {
        return this.mHmcInfo;
    }

    public UnsignedInt32 getTotalResponseLength() {
        return this.mTotalResponseLen;
    }

    public UnsignedInt16 getHeaderSize() {
        return this.mHeaderSize;
    }

    public UnsignedInt8 getHmcInfoCount() {
        return this.mHmcInfoCount;
    }

    public FspHmcInformation[] getFspHmcInfoList() {
        return this.mHmcInfoList;
    }

    public static UnsignedInt16[] getNumOfHMCInfoSlots(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_NUMBER_OF_HMC_INFO_SLOTS, null);
        UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{(UnsignedInt16)hashtable.get("NUMBER"), (UnsignedInt16)hashtable.get(SLOT)};
        return unsignedInt16Array;
    }

    FspHmcInfoData getHmcInfoCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException {
        if (unsignedInt16 == null) {
            unsignedInt16 = new UnsignedInt16(65535);
        }
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_HMC_INFO, new String[]{unsignedInt16.toString()});
        this.mCurSlotNum = (UnsignedInt16)hashtable.get(SLOT);
        byte[] byArray = (byte[])hashtable.get(INFO);
        this.mHmcInfo = byArray != null ? new String(byArray).trim() : " ";
        System.out.println("\n\nFspHmcInfo->getHmcInfo():\nslot=" + unsignedInt16.toString() + "\nmHmcInfo=" + this.mHmcInfo);
        return this;
    }

    static void setHmcInfoCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, String string) throws PIHscServerException {
        int n = 0;
        if (unsignedInt16 == null) {
            unsignedInt16 = new UnsignedInt16(65535);
        }
        if (string == null) {
            string = "";
        } else {
            n = string.length() / 2;
        }
        fSPCmdMgr.doPhypCommand(SET_HMC_INFO, new String[]{unsignedInt16.toString(), String.valueOf(n), string});
    }

    public FspHmcInfoData getAllHmcsInformationCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(GET_HMC_INFORMATION, null);
        this.mTotalResponseLen = (UnsignedInt32)hashtable.get(RESPONSE_LENGTH);
        this.mHeaderSize = (UnsignedInt16)hashtable.get(HEADER_SIZE);
        this.mHmcInfoCount = (UnsignedInt8)hashtable.get(REPEATS);
        Object[] objectArray = (Object[])hashtable.get(HMC_INFO_LIST);
        this.mHmcInfoList = new FspHmcInformation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            FspHmcInformation fspHmcInformation = new FspHmcInformation();
            Hashtable hashtable2 = (Hashtable)objectArray[i];
            fspHmcInformation.setHmcInformationSize((UnsignedInt16)hashtable2.get(STRUCT_LENGTH));
            fspHmcInformation.setHmcConnectionStatus((UnsignedInt8)hashtable2.get(CONNECTION_STATUS));
            fspHmcInformation.setToolType((UnsignedInt32)hashtable2.get(TOOL_TYPE));
            fspHmcInformation.setHmcIdLength((UnsignedInt16)hashtable2.get(HMC_ID_LENGTH));
            byte[] byArray = (byte[])hashtable2.get(HMC_ID);
            String string = new String(byArray).trim();
            fspHmcInformation.setHmcId(string);
            this.mHmcInfoList[i] = fspHmcInformation;
        }
        return this;
    }
}

